<?php
require_once("rsa.class.php");

class RSAProcessor
{
 private $public_key = null;
 private $private_key = "<RSAKeyValue><Modulus>rZtZlLmBf55fLbn5X1vWvyjdLf4znp1tTfrCOQrx8kHm73fT6PcIUFKYjfziaXhUoaxYGlF4BRCogSQE9/xGPX0HfEp0hRTawVKMLwE42W0Gh9rL4DgzxSPD6emWX1HJYhOROvxq8hKDncVAG9H+ENvq2J8TRH6T2ufiOoccoLE=</Modulus><Exponent>AQAB</Exponent><P>2Z/j9hjcuMUYj375cDm9WH8tyoRwYXGSo48H+HgQ0hd/LOD9jEOVNm/Mi/ekt9ioC5TZIiyi6PZT4tssEG+CSw==</P><Q>zDhj7YW5u9Pk9Lbvw5xHD2Vz+ZVErXwRlEn1Ti2i6lmbTRQ90/Vgf6oIKG/0LOdZiiBkcr5J40wlqrClNNercw==</Q><DP>VpXqIjE0KIOqyPURE5i1gC9hrbDR8cM5P8AZwL8smhplLBr8ZkFBbd4/ePT34XnfKnR3i8RMsPnI2HqxZnynTw==</DP><DQ>e6zWz3yBq786U/0JnNPisO9G2epM6idN2hkkBtFabUQQ6hANFXTvmMDXKe4K2LrOnfjZ/CdDRfTShtltY2ANAw==</DQ><InverseQ>qtbLXZ0Q+IXFs6mw7QPAu8g3RJQ1XTZYXMDHzyVYovc/EU2mNq0wAFcnO8yDeesowt5PXjNg9dX6Pl+oqca5Eg==</InverseQ><D>Ctb0VPDwQQOmdbhy9Z1KX00x4jlJB9JUjNXnYqBoUvQCc1lMBfPGtR0zIUp06Jj2z9Fu/tWvZMGRg9634LQDvqDE9cSl/uxKrusnP9x/G0Xiw/cO0NsW4d9ZH8VcuZntlSrmLqOWC2fJwyAmJKajhVig6DlOI4uiwS1ez9uodDE=</D></RSAKeyValue>";
 private $modulus = null;
 private $key_length = "1024";
 public function __construct($xmlRsakey=null,$type=null)
 {
         $xmlObj = null;
   if($xmlRsakey==null)          {
           $xmlObj = simplexml_load_file("xmlfile/RSAKey.xml");
          }
          elseif($type==RSAKeyType::XMLFile)          {
           $xmlObj = simplexml_load_file($xmlRsakey);
          }
          else          {
           $xmlObj = simplexml_load_string($xmlRsakey);
          }
        $this->modulus = RSA::binary_to_number(base64_decode($xmlObj->Modulus));
		$this->public_key = RSA::binary_to_number(base64_decode($xmlObj->Exponent));
		$this->private_key = RSA::binary_to_number(base64_decode($xmlObj->D));
		$this->key_length = strlen(base64_decode($xmlObj->Modulus))*8;
 }
 public function getPublicKey() {
  return $this->public_key;
 }
 public function getPrivateKey() {
  return $this->private_key;
 }
 public function getKeyLength() {
  return $this->key_length;
 }
 public function getModulus() {
  return $this->modulus;
 }
 public function encrypt($data) {
  return base64_encode(RSA::rsa_encrypt($data,$this->public_key,$this->modulus,$this->key_length));
 }
  public function dencrypt($data) {
  return RSA::rsa_decrypt($data,$this->private_key,$this->modulus,$this->key_length);
 }
  public function sign($data) {
  return RSA::rsa_sign($data,$this->private_key,$this->modulus,$this->key_length);
 }
  public function verify($data) {
  return RSA::rsa_verify($data,$this->public_key,$this->modulus,$this->key_length);
 }
}
class RSAKeyType{
 const XMLFile = 0;
 const XMLString = 1;
}